/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spider.util.maiquan.tts.baidu.summary;

import cn.com.duiba.spider.util.maiquan.tts.baidu.common.TokenHolder;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class BaiduSummaryUtil {
    private static final int MAX_LENGTH = 300;
    private static final int RETURN_LENGTH = 150;
    private static final String API_URL = "https://aip.baidubce.com/rpc/2.0/nlp/v1/news_summary?charset=UTF-8&access_token=%s";
    private static final TokenHolder TOKEN_HOLDER = new TokenHolder("NG08AwHezOTKpXUcQAzeSkw5", "KLDuiOMg6f60mw7s5eXm8LjxPwHrkjGK", "");

    public static String summary4Text(String title, String text, int length, int returnLength) {
        if (StringUtils.isBlank((String)title) || StringUtils.isBlank((String)text)) {
            return "";
        }
        try {
            String url = String.format(API_URL, TOKEN_HOLDER.refresh());
            length = length <= 0 ? 300 : length;
            returnLength = returnLength <= 0 ? 150 : returnLength;
            SummaryReq summaryReq = new SummaryReq(title, text, length);
            String body = Jsoup.connect((String)url).ignoreHttpErrors(true).ignoreContentType(true).timeout(5000).requestBody(summaryReq.toString()).method(Connection.Method.POST).execute().body();
            String summary = JSON.parseObject((String)body).getString("summary");
            if (StringUtils.isBlank((String)summary)) {
                return "";
            }
            if (summary.length() > returnLength) {
                return summary.substring(0, returnLength);
            }
            return summary;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String summary4Text(String title, String text) {
        return BaiduSummaryUtil.summary4Text(title, text, 300, 150);
    }

    private static class SummaryReq {
        private String title;
        private String content;
        private int max_summary_len;

        public SummaryReq(String title, String content, int max_summary_len) {
            this.title = title;
            this.content = content;
            this.max_summary_len = max_summary_len;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public int getMax_summary_len() {
            return this.max_summary_len;
        }

        public void setMax_summary_len(int max_summary_len) {
            this.max_summary_len = max_summary_len;
        }

        public String toString() {
            return JSON.toJSONString((Object)this);
        }
    }
}

