/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.velocity;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.context.ChainedContext;
import org.apache.velocity.tools.view.servlet.ServletToolboxManager;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.servlet.view.velocity.VelocityToolboxView;

public class FixedEmbeddedVelocityToolboxView
extends VelocityToolboxView {
    private ConcurrentMap<ServletContext, ServletContext> proxyedMap = new ConcurrentHashMap<ServletContext, ServletContext>(1);

    protected Context createVelocityContext(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ChainedContext context = new ChainedContext((Context)new VelocityContext(model), this.getVelocityEngine(), request, response, this.getServletContext());
        if (this.getToolboxConfigLocation() != null) {
            this.setContextToolbox(context);
        }
        return context;
    }

    private void setContextToolbox(ChainedContext context) {
        ServletToolboxManager toolboxManager = ServletToolboxManager.getInstance((ServletContext)this.getToolboxConfigFileAwareServletContext(), (String)this.getToolboxConfigLocation());
        Map toolboxContext = toolboxManager.getToolbox((Object)context);
        context.setToolbox(toolboxContext);
    }

    private ServletContext getToolboxConfigFileAwareServletContext() {
        ServletContext context = this.getServletContext();
        ServletContext proxtedContext = (ServletContext)this.proxyedMap.get(context);
        if (proxtedContext == null) {
            ProxyFactory factory = new ProxyFactory();
            factory.setTarget((Object)context);
            factory.addAdvice((Advice)new GetResourceMethodInterceptor(this.getToolboxConfigLocation()));
            proxtedContext = (ServletContext)factory.getProxy(((Object)((Object)this)).getClass().getClassLoader());
            ServletContext temp = this.proxyedMap.putIfAbsent(context, proxtedContext);
            if (temp != null) {
                proxtedContext = temp;
            }
        }
        return proxtedContext;
    }

    private static class GetResourceMethodInterceptor
    implements MethodInterceptor {
        private final String toolboxFile;

        GetResourceMethodInterceptor(String toolboxFile) {
            if (toolboxFile != null && !toolboxFile.startsWith("/")) {
                toolboxFile = "/" + toolboxFile;
            }
            this.toolboxFile = toolboxFile;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (invocation.getMethod().getName().equals("getResourceAsStream") && invocation.getArguments()[0].equals(this.toolboxFile)) {
                InputStream inputStream = (InputStream)invocation.proceed();
                if (inputStream == null) {
                    try {
                        inputStream = new ClassPathResource(this.toolboxFile, Thread.currentThread().getContextClassLoader()).getInputStream();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return inputStream;
            }
            return invocation.proceed();
        }
    }
}

