package cn.com.duiba.spring.boot.starter.autoconfigure.aaa;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Aspect
@Component
public class LogInfoAspect {

    @Pointcut("execution(* org.slf4j.helpers.NOPLogger.info(..))")
    public void pointcut() {}

    @Around("pointcut()")
    public Object process(ProceedingJoinPoint point) throws Throwable {
        if (Objects.isNull(PrintLogUtils.context)) {
            return point.proceed(point.getArgs());
        }

        if (PrintLogUtils.context.get()) {
            return point.proceed(point.getArgs());
        }
        return null;
    }



}
