package cn.com.duiba.spring.boot.starter.autoconfigure.tensorflow.support;

import cn.com.duiba.spring.boot.starter.autoconfigure.tensorflow.config.TFModelConfiguration;
import cn.com.duiba.spring.boot.starter.autoconfigure.tensorflow.enums.ChooseTFModelStrategyEnum;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StrategyFactory {

    private static final Map<String, ChooseTFModelStrategy> flyWeightMap = new ConcurrentHashMap<>();

    private static final Map<Integer, Class<?>> strategyMap = new HashMap<>();

    static {
        strategyMap.put(ChooseTFModelStrategyEnum.A.getStrategy(), StrategyA.class);
        strategyMap.put(ChooseTFModelStrategyEnum.B.getStrategy(), StrategyB.class);
        strategyMap.put(ChooseTFModelStrategyEnum.C.getStrategy(), StrategyC.class);
        strategyMap.put(ChooseTFModelStrategyEnum.SMOOTH_STRATEGY.getStrategy(), SmoothStrategy.class);
        strategyMap.put(ChooseTFModelStrategyEnum.WARMING_UP_STRATEGY.getStrategy(), WarmingUpStrategy.class);
        strategyMap.put(ChooseTFModelStrategyEnum.RANDOM_STRATEGY.getStrategy(), RandomStrategy.class);
        strategyMap.put(ChooseTFModelStrategyEnum.WEIGHT_RANDOM_STRATEGY.getStrategy(), WeightRandomStrategy.class);
    }

    public static ChooseTFModelStrategy getStrategy(String tfKey) {
        Integer strategy = TFModelConfiguration.strategy;
        String key = strategy + "->" +  tfKey;
        if (flyWeightMap.containsKey(key)) {
            return flyWeightMap.get(key);
        }
        Class<?> clazz = strategyMap.get(strategy);
        ChooseTFModelStrategy instance = null;
        try {
            instance = (ChooseTFModelStrategy)clazz.newInstance();
        } catch (Exception e) {
            e.printStackTrace();
        }
        flyWeightMap.put(key, instance);
        return instance;
    }

}
