package cn.com.duiba.spring.boot.starter.autoconfigure.aaa;


import com.alibaba.ttl.TransmittableThreadLocal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class PrintLogUtils {

    private static final Map<Integer, AtomicLong> map = new ConcurrentHashMap<>();

    static TransmittableThreadLocal<Boolean> context = new TransmittableThreadLocal<>();

    public static boolean getPrintLogFlag(Integer adxType) {
        if (!map.containsKey(adxType)) {
            map.put(adxType, new AtomicLong(1));
            return false;
        }
        AtomicLong atomicLong = map.get(adxType);
        if (atomicLong.get() % 3 == 0) {
            context.set(true);
            atomicLong.incrementAndGet();
            return true;
        }
        atomicLong.incrementAndGet();
        return false;

    }

}
