package cn.com.duiba.spring.boot.starter.autoconfigure.aaa;

import com.alibaba.ttl.TransmittableThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

@Component
public class ApolloLogger {

    private static final Logger logger = LoggerFactory.getLogger(ApolloLogger.class);

    private static TransmittableThreadLocal<Boolean> context = new TransmittableThreadLocal<>();

    private static TransmittableThreadLocal<Integer> adxTypeContext = new TransmittableThreadLocal<>();

    private static final Map<Integer, AtomicLong> map = new ConcurrentHashMap<>();

    /**
     * 环境变量deploy_type=fortress灰度  deploy_type=normal正式
     */
    private static String deploy_type = System.getenv("deploy_type");

    public void getPrintLogFlag(Integer adxType) {
        if (!map.containsKey(adxType)) {
            map.put(adxType, new AtomicLong(1));
            context.set(false);
            return;
        }
        AtomicLong atomicLong = map.get(adxType);
        if (atomicLong.get() % 3 == 0) {
            context.set(true);
            atomicLong.incrementAndGet();
            return;
        }
        context.set(false);
        atomicLong.incrementAndGet();
    }

    public void getPrintLogFlags(Integer adxType) {
        context.set(true);
    }

    private boolean infoFlag() {
        //if (ObjectUtils.notEqual(deploy_type, "normal")) {
          //  return true;
        //}
        Boolean flag = context.get();
        if (Objects.isNull(flag)) {
            return true;
        }
        return context.get();
    }

    /**
     * 打印日志信息
     */
    public void info(String format, Object... arguments) {
        if (infoFlag()) {
            logger.info(format, arguments);
        }
    }


}
