package cn.com.duiba.spring.boot.starter.autoconfigure.tensorflow.support;

import cn.com.duiba.spring.boot.starter.autoconfigure.tensorflow.config.TFModelConfiguration;
import cn.com.duiba.spring.boot.starter.autoconfigure.tensorflow.enums.ChooseTFModelStrategyEnum;
import java.util.HashMap;
import java.util.Map;

public class StrategyFactory {

    private static final Map<Integer, ChooseTFModelStrategy> strategyMap = new HashMap<>();

    static {
        strategyMap.put(ChooseTFModelStrategyEnum.A.getStrategy(), new StrategyA());
        strategyMap.put(ChooseTFModelStrategyEnum.B.getStrategy(), new StrategyB());
        strategyMap.put(ChooseTFModelStrategyEnum.C.getStrategy(), new StrategyC());
        strategyMap.put(ChooseTFModelStrategyEnum.SMOOTH_STRATEGY.getStrategy(), new SmoothStrategy());
        strategyMap.put(ChooseTFModelStrategyEnum.WARMING_UP_STRATEGY.getStrategy(), new WarmingUpStrategy());
        strategyMap.put(ChooseTFModelStrategyEnum.RANDOM_STRATEGY.getStrategy(), new RandomStrategy());
        strategyMap.put(ChooseTFModelStrategyEnum.WEIGHT_RANDOM_STRATEGY.getStrategy(), new WeightRandomStrategy());
    }

    public static ChooseTFModelStrategy getStrategy() {
        Integer strategy = TFModelConfiguration.strategy;
        if (!strategyMap.containsKey(strategy)) {
            return strategyMap.get(ChooseTFModelStrategyEnum.B.getStrategy());
        }
        return strategyMap.get(strategy);
    }

}
