package cn.com.duiba.spring.boot.starter.autoconfigure.aaa;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import java.lang.reflect.Method;

@Aspect
@Component
@EnableAspectJAutoProxy
public class COntroller {

    @Autowired
    private ApolloLogger apolloLogger;

    @Pointcut(value = "@annotation(org.springframework.web.bind.annotation.RestController) || @annotation(org.springframework.stereotype.Controller)")
    public void pointcut() {}

    @Before(value = "pointcut()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        Class<?> clazz = joinPoint.getTarget().getClass();
        String methodName = joinPoint.getSignature().getName();
        Method method = clazz.getMethod(methodName);
        RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
        String[] value = requestMapping.value();
        if (value[0].contains("bid")) {
            //apolloLogger.getPrintLogFlag();
        }

    }

}
