package cn.com.duiba.spring.boot.starter.autoconfigure.aaa;

import com.alibaba.ttl.TransmittableThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import java.util.Objects;

@Component
public class SamplingLogger {

    private static final Logger logger = LoggerFactory.getLogger(SamplingLogger.class);

    public void info(String format, Object... arguments) {
        TransmittableThreadLocal<Boolean> context = SamplingThreadLocal.context;
        if (Objects.isNull(context)) {
            return;
        }

        if (context.get()) {
            logger.info(format, arguments);
        }

    }
}
