package cn.com.duiba.spring.boot.starter.autoconfigure.trace;

import com.alibaba.ttl.TransmittableThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import java.util.Objects;

@Component
public class SamplingLogger {

    private static final Logger logger = LoggerFactory.getLogger(SamplingLogger.class);

    public void info(String format, Object... arguments) {
        TransmittableThreadLocal<Boolean> context = SamplingThreadLocal.getContext();
        if (Objects.isNull(context)) {
            return;
        }

        if (Objects.isNull(context.get())) {
            return;
        }

        if (context.get()) {
            logger.info(format, arguments);
        }

    }
}
