package cn.com.duiba.sso.api.web.filter;

import java.util.List;
import java.util.Set;

import javax.servlet.FilterChain;

import cn.com.duiba.sso.api.web.annotation.SsoComponent;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.sso.api.web.factory.SsoBeanAware;
import cn.com.duiba.sso.api.web.filter.filterhandler.SsoFilterHandler;
import cn.com.duiba.wolf.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;

import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;

/**
 * Created by liuyao on 2017/5/11.
 */
@SsoComponent
public class SsoFilterHandlerQueue implements SsoBeanAware {

    private Logger logger = LoggerFactory.getLogger(SsoFilterHandlerQueue.class);

    private List<SsoFilterHandler> queueHandlerList;

    private Integer length = 0;


    public void setContext(SsoContext context){
        try{
            List<Class<?>> classes =ClassUtils.getClassList("cn.com.duiba.sso.api.web.filter.filterhandler.handler",true,null);

            List<SsoFilterHandler> handlerList = Lists.newArrayList();
            Set<Integer> orderSet = Sets.newHashSet();

            for(Class clazz : classes){
                if(SsoFilterHandler.class.isAssignableFrom(clazz)){
                    SsoFilterHandler ssoFilterHandler = (SsoFilterHandler)context.getBean(clazz);
                    orderSet.add(ssoFilterHandler.getOrder());
                    handlerList.add(ssoFilterHandler);
                }
            }
            if(orderSet.size()!=handlerList.size()){
                throw new SsoRunTimeException("Sso拦截序列存在");
            }
            //排序
            Ordering ordering = Ordering.natural().onResultOf(new Function<SsoFilterHandler,Integer>() {
                @Override
                public Integer apply(SsoFilterHandler input) {
                    return input.getOrder();
                }
            });
            queueHandlerList = ordering.sortedCopy(handlerList);
            length = queueHandlerList.size();

            logger.error("检测到拦截队列数:"+length);
        }catch (Exception e){
            new SsoRunTimeException(e);
        }
    }

    public void doHandler(FilterChain chain) throws SsoException {
        for(SsoFilterHandler handler:queueHandlerList){
            boolean doNext = handler.doHandler(chain);//至少存在一个默认的handler
            if(!doNext){
                break;
            }
        }
    }

    public Integer size(){
        return length;
    }
}
