/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.tool;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.PermissionDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestParams;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.logger.domain.SsoLoggerParams;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RequestTool
implements ApplicationContextAware {
    private static ThreadLocal<RequestTool> local = new ThreadLocal();
    private static RemoteAdminService remoteAdminService;
    private static RemotePermissionService remotePermissionService;
    private static RemoteSSOService remoteSSOService;
    private static RemoteManagerLogService remoteManagerLogService;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private RequestParams params;

    public static void setRequestInThreadLocal(HttpServletRequest request, HttpServletResponse response) {
        if (request == null) {
            throw new SsoRunTimeException("RequestTool\u6ce8\u5165request\u4e3a\u7a7a");
        }
        if (response == null) {
            throw new SsoRunTimeException("RequestTool\u6ce8\u5165response\u4e3a\u7a7a");
        }
        RequestTool tool = new RequestTool();
        tool.request = request;
        tool.response = response;
        tool.params = RequestParams.parse(request);
        local.set(tool);
    }

    private static RequestTool get() {
        if (local.get() == null) {
            throw new SsoRunTimeException("\u8bf7\u5728\u767b\u5f55\u62e6\u622a\u5668\u4e2d\u8c03\u7528setRequestInThreadLocal");
        }
        return local.get();
    }

    public static RequestParams getRequestParams() {
        return RequestTool.get().params.clone();
    }

    public static HttpServletResponse getResponse() {
        return RequestTool.get().response;
    }

    public static HttpServletRequest getRequest() {
        return RequestTool.get().request;
    }

    public static void removeRequestInThreadLocal() {
        local.remove();
    }

    public static Long getAdminId() {
        AdminDto admin = RequestTool.getAdmin();
        return admin.getId();
    }

    public static AdminDto getAdmin() {
        RequestTool tool = RequestTool.get();
        return tool.params.getAdmin();
    }

    public static void setAdmin(AdminDto admin) {
        RequestTool tool = RequestTool.get();
        tool.params.setAdmin(admin);
    }

    public static void addCookie(Cookie cookie) {
        if (cookie == null) {
            return;
        }
        RequestTool tool = RequestTool.get();
        tool.params.addCookie(cookie.getName(), cookie.getValue());
        tool.response.addCookie(cookie);
    }

    public static String getUrl() {
        return RequestTool.get().params.getUrl();
    }

    public static boolean isHttpsRequest() {
        HttpServletRequest request = RequestTool.get().request;
        return "true".equals(request.getHeader("Use-Https"));
    }

    public static String getCookie(String name) {
        RequestTool tool = RequestTool.get();
        return tool.params.getCookie(name);
    }

    public static Map<String, String> getRequestParamMap() {
        HttpServletRequest request = RequestTool.get().request;
        Map map = request.getParameterMap();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            resultMap.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return resultMap;
    }

    public static Boolean isAsynchronousRequests() {
        HttpServletRequest request = RequestTool.get().request;
        String re = request.getHeader("x-requested-with");
        String accept = request.getHeader("Accept");
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{re}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accept}) && accept.contains("json");
    }

    public static String getIp() {
        RequestTool tool = RequestTool.get();
        return tool.params.getIp();
    }

    public static Boolean isLocalHost() {
        RequestTool tool = RequestTool.get();
        return Objects.equal((Object)tool.params.getIp(), (Object)"127.0.0.1");
    }

    public static void googleVerify(String code) throws SsoException {
        RequestTool tool = RequestTool.get();
        Long adminId = RequestTool.getAdminId();
        DubboResult result = remoteAdminService.googleVerify(adminId, code);
        if (!result.isSuccess()) {
            throw new SsoException(result.getMsg());
        }
    }

    @Deprecated
    public static List<PermissionDto> getPermissions() throws RuntimeException {
        Integer adminId = RequestTool.getAdminId().intValue();
        Integer systemId = SystemInfo.getThisSystemId().intValue();
        DubboResult result = remotePermissionService.getPermissions(adminId.intValue(), systemId.intValue());
        List permissionDtoList = (List)result.getResult();
        return permissionDtoList;
    }

    public static String findTicket() {
        String ticketForUrl = RequestTool.getRequestParamMap().get("sso_ticket");
        if (StringUtils.isNotBlank((CharSequence)ticketForUrl)) {
            return ticketForUrl;
        }
        return CookieUtil.getCookie("sso_ticket");
    }

    public static void outLogin() {
        CookieUtil.deleteCookie("sso_ticket");
        String ticket = RequestTool.findTicket();
        if (StringUtils.isBlank((CharSequence)ticket)) {
            return;
        }
        remoteSSOService.removeTicket(ticket);
    }

    @Deprecated
    public static void sendOperationLog(SsoLoggerParams ssoLoggerParams) {
        remoteManagerLogService.log(ssoLoggerParams);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        remoteAdminService = (RemoteAdminService)context.getBean(RemoteAdminService.class);
        remotePermissionService = (RemotePermissionService)context.getBean(RemotePermissionService.class);
        remoteSSOService = (RemoteSSOService)context.getBean(RemoteSSOService.class);
        remoteManagerLogService = (RemoteManagerLogService)context.getBean(RemoteManagerLogService.class);
    }
}

