/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.handler;

import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.tool.RequestParams;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.SsoFilterHandler;
import cn.com.duiba.sso.api.web.logger.runnable.AccessLoggerRunnable;
import cn.com.duiba.sso.api.web.logger.service.SsoLoggerService;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccessLogFilterHandler
extends SsoFilterHandler {
    @Resource
    private SsoLoggerService ssoLoggerService;
    @Autowired
    private PowerTreeService powerCacheService;
    private Joiner joiner = Joiner.on((String)",").skipNulls();

    public int getOrder() {
        return -98;
    }

    @Override
    public Boolean doHandler(Object handler) {
        RequestParams params = RequestTool.getRequestParams();
        AccessLoggerRunnable runnable = new AccessLoggerRunnable();
        runnable.setRequestParams(params);
        Set powerIds = this.powerCacheService.getPowerIdsByUrl(params.getUri());
        if (!powerIds.isEmpty()) {
            Long powerId = (Long)Lists.newArrayList((Iterable)powerIds).get(0);
            List powerList = this.powerCacheService.getPowerWay(powerId);
            runnable.setRequestFunction(this.joiner.join((Iterable)powerList.stream().map(PowerDto::getName).collect(Collectors.toList())));
        } else {
            runnable.setRequestFunction("\u672a\u6dfb\u52a0\u6743\u9650\u6620\u5c04");
        }
        this.ssoLoggerService.sendAccessLog(runnable);
        return true;
    }
}

