/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.handler;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.properties.SsoProperties;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.SsoFilterHandler;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import java.net.URLEncoder;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class LoginFilterHandler
extends SsoFilterHandler {
    @Resource
    private RemoteSSOService remoteSSOService;
    @Resource
    private SsoProperties properties;

    public int getOrder() {
        return -100;
    }

    @Override
    public Boolean doHandler(Object handler) {
        String ticket = RequestTool.findTicket();
        if (StringUtils.isBlank((CharSequence)ticket)) {
            this.returnNotLogin();
            return false;
        }
        DubboResult adminIdRes = this.remoteSSOService.verifyTicketToAdmin(ticket);
        if (!adminIdRes.isSuccess() || Objects.equal(null, (Object)adminIdRes.getResult())) {
            this.returnNotLogin();
            return false;
        }
        AdminDto admin = (AdminDto)adminIdRes.getResult();
        RequestTool.setAdmin(admin);
        if (RequestTool.getRequestParamMap().containsKey("sso_ticket")) {
            CookieUtil.setCookie("sso_ticket", ticket);
        }
        return true;
    }

    private void returnNotLogin() {
        try {
            if (RequestTool.isAsynchronousRequests().booleanValue()) {
                RequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                JSONObject model = new JSONObject();
                model.put("code", (Object)"SSO:01001");
                model.put("success", (Object)false);
                model.put("notLogin", (Object)true);
                RequestTool.getResponse().getWriter().write(model.toJSONString());
            } else {
                String url;
                if ("/".equals(this.properties.getDefaultRedirectUrl())) {
                    url = URLEncoder.encode(RequestTool.getUrl(), "utf-8");
                } else {
                    String scheme = RequestTool.getRequest().getScheme();
                    String serverName = RequestTool.getRequest().getServerName();
                    int port = RequestTool.getRequest().getServerPort();
                    String domainUrl = scheme + "://" + serverName + ":" + port;
                    url = URLEncoder.encode(domainUrl + this.properties.getDefaultRedirectUrl(), "utf-8");
                }
                RequestTool.getResponse().sendRedirect(this.getLoginRedirectUrl(url));
            }
        }
        catch (Exception e) {
            throw new SsoRunTimeException((Throwable)e);
        }
    }

    private String getLoginRedirectUrl(String redirect) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getLoginUrl()).append("?redirect=").append(redirect);
        builder.append("&system=").append(SystemInfo.getThisSystemId());
        return builder.toString();
    }

    private String getLoginUrl() {
        return this.properties.getSsoSystemUrl() + "/login";
    }
}

