/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.logger;

import cn.com.duiba.sso.api.web.logger.SsoLogger;
import cn.com.duiba.sso.api.web.logger.annotation.SsoLoggerMethod;
import cn.com.duiba.sso.api.web.logger.domain.SsoLoggerTheadContext;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SsoLoggerInterceptor {
    @Pointcut(value="@annotation(cn.com.duiba.sso.api.web.logger.annotation.SsoLoggerMethod)")
    public void logger() {
    }

    @Before(value="logger()")
    public void loggerBefore(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        SsoLoggerMethod ssoLoggerMethod = (SsoLoggerMethod)AnnotationUtils.findAnnotation((Method)method, SsoLoggerMethod.class);
        String template = ssoLoggerMethod.value();
        String group = ssoLoggerMethod.group();
        SsoLoggerTheadContext context = new SsoLoggerTheadContext();
        context.setTemplate(template);
        context.setGroup(group);
        SsoLogger.setSsoLoggerTheadContext(context);
    }

    @After(value="logger()")
    public void loggerAfter() {
        SsoLogger.flush();
    }
}

