/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.logger.runnable;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.tool.RequestParams;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.logger.domain.AccessLog;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AccessLoggerRunnable
implements Runnable {
    private RequestParams requestParams;
    private RemoteManagerLogService remoteManagerLogService;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String requestFunction;

    @Override
    public void run() {
        AdminDto admin = this.requestParams.getAdmin();
        SystemDto thisSystem = SystemInfo.getThisSystemInfo();
        AccessLog accessLog = new AccessLog();
        accessLog.setAccessUser(admin.getName());
        accessLog.setRequestUrl(this.requestParams.getUrl());
        accessLog.setRequestUri(this.requestParams.getUri());
        accessLog.setIp(this.requestParams.getIp());
        accessLog.setSystemId(thisSystem.getId());
        accessLog.setBusinessSystem(thisSystem.getAppName());
        accessLog.setAccessTime(this.sdf.format(new Date()));
        accessLog.setRequestFunction(this.requestFunction);
        this.remoteManagerLogService.appendAccessLog(accessLog);
    }

    public void setRequestParams(RequestParams requestParams) {
        this.requestParams = requestParams;
    }

    public void setRequestFunction(String requestFunction) {
        this.requestFunction = requestFunction;
    }

    public void setRemoteManagerLogService(RemoteManagerLogService remoteManagerLogService) {
        this.remoteManagerLogService = remoteManagerLogService;
    }
}

