/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.logger.service;

import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.tool.RequestParams;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.logger.SsoLogger;
import cn.com.duiba.sso.api.web.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.web.logger.runnable.AccessLoggerRunnable;
import cn.com.duiba.sso.api.web.logger.runnable.SsoLoggerRunnable;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class SsoLoggerService
implements InitializingBean {
    @Resource
    private ExecutorService executorService;
    @Resource
    private RemoteManagerLogService remoteManagerLogService;
    private ThreadLocal<SsoLoggerTheadContext> threadContext = new ThreadLocal();

    public void log(JSONObject json) {
        this.threadContext.get().addParams(json);
    }

    public void setThreadContext(SsoLoggerTheadContext context) {
        if (this.threadContext.get() == null) {
            this.threadContext.set(context);
        }
    }

    public void flushThreadContext() {
        SsoLoggerTheadContext context = this.threadContext.get();
        if (Objects.equal(null, (Object)context)) {
            return;
        }
        RequestParams params = RequestTool.getRequestParams();
        SsoLoggerRunnable runnable = new SsoLoggerRunnable();
        runnable.setRequestParams(params);
        runnable.setContext(context);
        runnable.setRemoteManagerLogService(this.remoteManagerLogService);
        this.executorService.submit(runnable);
        this.threadContext.remove();
    }

    public void afterPropertiesSet() throws Exception {
        SsoLogger.setSsoLoggerService(this);
    }

    public void sendAccessLog(AccessLoggerRunnable runnable) {
        runnable.setRemoteManagerLogService(this.remoteManagerLogService);
        this.executorService.submit(runnable);
    }
}

