/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.power;

import cn.com.duiba.sso.api.common.tree.TreeView;
import cn.com.duiba.sso.api.domain.bizenum.CacheKeyEnum;
import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.domain.event.AdminOutLoginEvent;
import cn.com.duiba.sso.api.domain.event.RoleUpdateEvent;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.service.eventbus.BizEventListener;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.power.PowerCache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
@BizEventListener
public class AdminPowerCacheService {
    private LoadingCache<Long, PowerCache> adminPowerCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build((CacheLoader)new AdminRoleCacheLoader());
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private RemotePermissionService remotePermissionService;
    @Autowired
    private PowerTreeService powerTreeService;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    @PostConstruct
    public void init() {
        this.executorService.scheduleWithFixedDelay(new AdminPowerFlushTask(), 30L, 30L, TimeUnit.SECONDS);
    }

    private PowerCache getPowerCache(Long adminId) {
        try {
            return (PowerCache)this.adminPowerCache.get((Object)adminId);
        }
        catch (Exception e) {
            throw new SsoRunTimeException((Throwable)e);
        }
    }

    public Boolean hasPower(Long adminId, String url) {
        Set pawerIds = this.powerTreeService.getPowerIdsByUrl(url);
        if (pawerIds.isEmpty()) {
            return true;
        }
        PowerCache cache = this.getPowerCache(adminId);
        return !Sets.intersection((Set)pawerIds, cache.getPowerIdSet()).isEmpty();
    }

    public <T extends TreeView<T>> List<T> powerForAdmin(Long adminId, Function<PowerDto, T> transform) {
        PowerCache cache = this.getPowerCache(adminId);
        return this.powerTreeService.getPowerTree(cache.getPowerIdSet(), transform);
    }

    public Set<String> getAllPowerRes(Long adminId) {
        PowerCache cache = this.getPowerCache(adminId);
        Set<Long> powerIds = cache.getPowerIdSet();
        HashSet urlSet = Sets.newHashSet();
        for (Long id : powerIds) {
            PowerDto power = this.powerTreeService.getPower(id);
            if (power == null) continue;
            urlSet.addAll(power.getUrls());
        }
        return urlSet;
    }

    @Subscribe
    public void AdminOutLoginEventListener(AdminOutLoginEvent event) {
        this.flushAdminPower(event.getAdminId());
    }

    @Subscribe
    public void RoleUpdateEventListener(RoleUpdateEvent event) {
        for (Long adminId : event.getAdminIds()) {
            this.flushAdminPower(adminId);
        }
    }

    private void flushAdminPower(Long adminId) {
        Long systemId = SystemInfo.getThisSystemId();
        String key = CacheKeyEnum.SSO_ADMIN_POWER_CONFIG_VERSION.getCacheKey(new Object[]{systemId, adminId});
        BoundValueOperations operations = this.stringRedisTemplate.boundValueOps((Object)key);
        operations.set((Object)String.valueOf(new Date().getTime()), 1L, TimeUnit.DAYS);
    }

    private class AdminPowerFlushTask
    implements Runnable {
        private AdminPowerFlushTask() {
        }

        @Override
        public void run() {
            Long systemId = SystemInfo.getThisSystemId();
            Set adminIds = AdminPowerCacheService.this.adminPowerCache.asMap().keySet();
            for (Long adminId : adminIds) {
                String key = CacheKeyEnum.SSO_ADMIN_POWER_CONFIG_VERSION.getCacheKey(new Object[]{systemId, adminId});
                BoundValueOperations operations = AdminPowerCacheService.this.stringRedisTemplate.boundValueOps((Object)key);
                String versionStr = (String)operations.get();
                if (StringUtils.isBlank((CharSequence)versionStr)) {
                    return;
                }
                Long version = Long.valueOf(versionStr);
                PowerCache cache = (PowerCache)AdminPowerCacheService.this.adminPowerCache.getIfPresent((Object)adminId);
                if (cache == null) {
                    return;
                }
                if (cache.getVersion() >= version) {
                    return;
                }
                AdminPowerCacheService.this.adminPowerCache.invalidate((Object)adminId);
            }
        }
    }

    private class AdminRoleCacheLoader
    extends CacheLoader<Long, PowerCache> {
        private AdminRoleCacheLoader() {
        }

        public PowerCache load(Long adminId) {
            Long systemId = SystemInfo.getThisSystemId();
            String key = CacheKeyEnum.SSO_ADMIN_POWER_CONFIG_VERSION.getCacheKey(new Object[]{systemId, adminId});
            BoundValueOperations operations = AdminPowerCacheService.this.stringRedisTemplate.boundValueOps((Object)key);
            String versionStr = (String)operations.get();
            Long version = Optional.ofNullable(versionStr).map(Long::valueOf).orElse(new Date().getTime());
            Set powerIds = AdminPowerCacheService.this.remotePermissionService.getPowerIdsBySystemIdAndAdminId(systemId, adminId);
            PowerCache cache = new PowerCache(version);
            cache.setPowerIdSet(powerIds);
            if (StringUtils.isBlank((CharSequence)versionStr)) {
                operations.set((Object)version.toString(), 1L, TimeUnit.DAYS);
            }
            return cache;
        }
    }
}

