package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Set;

@Controller
@RequestMapping("/auth")
public class AuthController {

    @Autowired
    private AdminPowerCacheService adminPowerCacheService;

    /**
     * 获取用户白名单
     * @return
     */
    @ResponseBody
    @RequestMapping("/getAuthList")
    public JsonRender getAdminAuthList(){
        Set<String> urlSet = adminPowerCacheService.getAllPowerRes(RequestTool.getAdminId());
        JSONObject json = new JSONObject();
        json.put("authList",Lists.newArrayList(urlSet));
        return JsonRender.successResult(json);
    }
}
