package cn.com.duiba.sso.api.web.interceptor.handler;

import javax.annotation.Resource;

import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.web.logger.runnable.AccessLoggerRunnable;
import cn.com.duiba.sso.api.web.logger.service.SsoLoggerService;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.tool.RequestParams;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.sso.api.web.interceptor.SsoFilterHandler;
import cn.com.duiba.sso.api.tool.RequestTool;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Created by liqing on 2017/7/27.
 */
@Component
public class AccessLogFilterHandler extends SsoFilterHandler {

    @Resource
    private SsoLoggerService ssoLoggerService;
    @Autowired
    private PowerTreeService powerCacheService;

    private Joiner joiner = Joiner.on(",").skipNulls();

    @Override
    public int getOrder() {
        return -98;
    }

    @Override
    public Boolean doHandler(Object handler){

        RequestParams params = RequestTool.getRequestParams();

        AccessLoggerRunnable runnable = new AccessLoggerRunnable();
        runnable.setRequestParams(params);

        Set<Long> powerIds = powerCacheService.getPowerIdsByUrl(params.getUri());
        if(!powerIds.isEmpty()){
            Long powerId = Lists.newArrayList(powerIds).get(0);
            List<PowerDto> powerList = powerCacheService.getPowerWay(powerId);
            runnable.setRequestFunction(joiner.join(powerList.stream().map(PowerDto::getName).collect(Collectors.toList())));
        }else {
            runnable.setRequestFunction("未添加权限映射");
        }
        ssoLoggerService.sendAccessLog(runnable);
        return true;
    }


}
