package cn.com.duiba.sso.api.web.interceptor.handler;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.web.interceptor.SsoFilterHandler;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import cn.com.duiba.sso.api.domain.properties.SsoProperties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.net.URLEncoder;

/**
 * Created by liuyao on 2017/5/11.
 * 单点登录拦截系统
 */
@Component
public class LoginFilterHandler extends SsoFilterHandler {

    private static Logger logger = LoggerFactory.getLogger(LoginFilterHandler.class);

    @Resource
    private RemoteSSOService remoteSSOService;
    @Resource
    private SsoProperties properties;

    @Override
    public int getOrder() {
        return -100;
    }

    @Override
    public Boolean doHandler(Object handler){
        String ticket = RequestTool.findTicket();
        if(StringUtils.isBlank(ticket)){
            returnNotLogin();
            return false;
        }
        try{
            AdminDto admin = remoteSSOService.verifyTicketAndGetAdmin(ticket);
            if(admin==null){
                throw new SsoException("通行证失效");
            }
            //注入adminId
            RequestTool.setAdmin(admin);
            //当通行令牌存在于链接参数中时,则把它持久到cookie中(链接中通行证的参数名和链接中的相同)
            if(RequestTool.getRequestParamMap().containsKey(CookieUtil.LOGIN_COOKIE_NAME)){
                CookieUtil.setCookie(CookieUtil.LOGIN_COOKIE_NAME,ticket);
            }
            return true;
        }catch (Exception e){
            logger.info("通行证验证失败",e);
            returnNotLogin();
            return false;
        }
    }

    private void returnNotLogin(){
        try{
            if(RequestTool.isAsynchronousRequests()){
                RequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                JSONObject model = new JSONObject();
                model.put("code","SSO:01001");
                model.put("success",false);
                model.put("notLogin",true);
                RequestTool.getResponse().getWriter().write(model.toJSONString());
            }else{
                //附上当前请求地址,重定向到SSO登录页
                HttpServletRequest request = RequestTool.getRequest();
                String redirect;
                if(StringUtils.equals("/",request.getRequestURI())){
                    redirect = getHomeURL()+properties.getDefaultRedirectUrl();
                }else{
                    redirect = RequestTool.getUrl();
                }
                redirect = URLEncoder.encode(redirect,"utf-8");
                RequestTool.getResponse().sendRedirect(getLoginRedirectUrl(redirect));
            }
        }catch (Exception e){
            throw new SsoRunTimeException(e);
        }
    }


    /**
     * 获取登录重定向地址
     * @param redirect
     * @return
     */
    private String getLoginRedirectUrl(String redirect){
        StringBuilder builder = new StringBuilder();
        builder.append(getLoginUrl()).append("?redirect=").append(redirect);
        builder.append("&systemId=").append(SystemInfo.getThisSystemId());
        return builder.toString();
    }

    private String getHomeURL(){
        String scheme = RequestTool.getRequest().getScheme();
        String serverName = RequestTool.getRequest().getServerName();
        int port = RequestTool.getRequest().getServerPort();
        return scheme + "://" + serverName + ":" + port;
    }

    private String getLoginUrl(){
        return properties.getSsoSystemUrl() + "/login";
    }
}
