package cn.com.duiba.sso.api.web.logger;

import cn.com.duiba.sso.api.web.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.web.logger.service.SsoLoggerService;
import com.alibaba.fastjson.JSONObject;

import java.util.Map;

/**
 * Created by liuyao on 2017/6/19.
 * 管理员日志打印者
 */
public class SsoLogger {

    private static volatile SsoLoggerService ssoLoggerService;

    /**
     * 根据简单打印日志,简单类将被JSON序列化
     * @param params
     */
    public static void logForPojo(Object params){
        JSONObject json = new JSONObject();
        if(params instanceof Map){
            json.putAll((Map)params);
        }else{
            String jsonStr = JSONObject.toJSONString(params);
            json.putAll(JSONObject.parseObject(jsonStr));
        }
        logForJson(json);
    }

    /**
     * 请求线程前置调用
     * @param context
     */
    public static void setSsoLoggerTheadContext(SsoLoggerTheadContext context){
        ssoLoggerService.setThreadContext(context);
    }

    /**
     * 请求线程后置调用
     */
    public static void flush(){
        ssoLoggerService.flushThreadContext();
    }

    /**
     * 通过json渲染日志
     * @param params
     */
    public static void logForJson(JSONObject params){
        ssoLoggerService.log(params);
    }

    public static void setSsoLoggerService(SsoLoggerService ssoLoggerService) {
        SsoLogger.ssoLoggerService = ssoLoggerService;
    }
}
