package sso.spring.config;

import cn.com.duiba.sso.api.SsoBasicConfiguration;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.SsoInterceptor;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import cn.com.duiba.sso.api.domain.properties.SsoProperties;

import javax.annotation.Resource;

@Configuration
@ComponentScan("cn.com.duiba.sso.api.web")
@ConditionalOnWebApplication
@EnableConfigurationProperties(SsoProperties.class)
@Import({SsoBasicConfiguration.class,SsoInterceptor.class})//引入SSO基础配置
public class SsoAutoConfiguration extends WebMvcConfigurerAdapter {

    @Resource
    private SsoInterceptor ssoInterceptor;

    @Resource
    private SsoProperties ssoProperties;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        String pathPatterns = ssoProperties.getPathPatterns();
        String excludePathPatterns = ssoProperties.getExcludePathPatterns();

        String[] paths = StringUtils.isEmpty(pathPatterns) ? new String[]{"/**"} : StringUtils.split(pathPatterns,",");
        String[] excludePath = StringUtils.isEmpty(excludePathPatterns) ? new String[]{} : StringUtils.split(excludePathPatterns,",");
        registry.addInterceptor(ssoInterceptor).addPathPatterns(paths).excludePathPatterns(excludePath);
        super.addInterceptors(registry);
    }

    /**
     * 初始化RequestTool
     * @return
     */
    @Bean
    public RequestTool initRequestTool(){
        return new RequestTool();
    }
}
