package cn.com.duiba.sso.api;

import cn.com.duiba.sso.api.SsoBasicConfiguration;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.MobileInterceptor;
import cn.com.duiba.sso.api.web.interceptor.SsoInterceptor;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import cn.com.duiba.sso.api.constants.SsoProperties;

import javax.annotation.Resource;

@Configuration
@ComponentScan("cn.com.duiba.sso.api.web")
@ConditionalOnWebApplication
@AutoConfigureAfter(SsoBasicConfiguration.class)
@EnableConfigurationProperties(SsoProperties.class)
@Import({SsoBasicConfiguration.class})//引入SSO基础配置
public class SsoAutoConfiguration extends WebMvcConfigurerAdapter {
    @Resource
    private SsoInterceptor ssoInterceptor;
    @Resource
    private MobileInterceptor mobileInterceptor;
    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private SsoLoggerService ssoLoggerService;
    @Resource
    private SsoLoggerMateInfoAdapter ssoLoggerMateInfoAdapter;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        String pathPatterns = ssoProperties.getPathPatterns();
        String excludePathPatterns = ssoProperties.getExcludePathPatterns();

        String[] paths = StringUtils.split(pathPatterns,",");
        String[] excludePath = StringUtils.isEmpty(excludePathPatterns) ? new String[]{} : StringUtils.split(excludePathPatterns,",");
        InterceptorRegistration registration = registry.addInterceptor(ssoInterceptor).addPathPatterns(paths).addPathPatterns("/auth/**").excludePathPatterns(excludePath);
        super.addInterceptors(registry);

        //注入日志源数据获取策略
        ssoLoggerService.setSsoLoggerMateInfoAdapter(ssoLoggerMateInfoAdapter);

        //开启移动端功能
        if(!ssoProperties.getMobileEnable()){
            return;
        }

        String mobilePathPatterns = ssoProperties.getMobilePathPatterns();
        String[] mobilePaths = StringUtils.split(mobilePathPatterns,",");
        //PC端将移动端的链接全部排除
        registration.excludePathPatterns(mobilePaths);

        InterceptorRegistration mobileRegistration = registry.addInterceptor(mobileInterceptor).addPathPatterns(mobilePaths).addPathPatterns("/auth/**").excludePathPatterns(excludePath);
        //移动端将PC端
        if(!StringUtils.equals(pathPatterns,"/**")){
            mobileRegistration.excludePathPatterns(paths);
        }

    }

    /**
     * 初始化RequestTool
     * @return
     */
    @Bean
    public RequestTool initRequestTool(){
        return new RequestTool();
    }
}
