package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.net.URLEncoder;

public abstract class AbstractLoginFilterHandler implements SsoFilterHandler {


    @Override
    public int getOrder(){
        return 0;
    }

    public abstract Boolean before(Object handler);

    protected abstract String getDefaultRedirectUrl();

    protected abstract String getLoginRedirectUrl(String redirect);

    protected void returnNotLogin(){
        try{
            if(RequestTool.isAsynchronousRequests()){
                RequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                JSONObject model = new JSONObject();
                model.put("code","SSO:01001");
                model.put("success",false);
                model.put("notLogin",true);
                RequestTool.getResponse().getWriter().write(model.toJSONString());
            }else{
                //附上当前请求地址,重定向到SSO登录页
                HttpServletRequest request = RequestTool.getRequest();
                String redirect;
                if(StringUtils.equals("/",request.getRequestURI())){
                    redirect = RequestTool.getHomeURL()+getDefaultRedirectUrl();
                }else{
                    redirect = RequestTool.getUrl();
                }
                redirect = URLEncoder.encode(redirect,"utf-8");
                RequestTool.getResponse().sendRedirect(getLoginRedirectUrl(redirect));
            }
        }catch (Exception e){
            throw new SsoRunTimeException(e);
        }
    }

}
