package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import javax.annotation.Resource;

import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.service.logger.runnable.AccessLoggerRunnable;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerService;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.tool.RequestParams;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.sso.api.tool.RequestTool;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Created by liqing on 2017/7/27.
 * 去除访问日志(没有具体的可用性)
 */
@Deprecated
public class AccessLogFilterHandler implements SsoFilterHandler {

    @Resource
    private SsoLoggerService ssoLoggerService;
    @Autowired
    private PowerTreeService powerCacheService;
    @Autowired
    private SsoLoggerMateInfoAdapter ssoLoggerMateInfoAdapter;

    private Joiner joiner = Joiner.on(",").skipNulls();

    @Override
    public int getOrder() {
        return 15;
    }

    @Override
    public Boolean before(Object handler){

        RequestParams params = RequestTool.getRequestParams();
        if(params==null){
            return true;
        }
        AccessLoggerRunnable runnable = new AccessLoggerRunnable();
        runnable.setAdminId(RequestTool.getAdminId());
        runnable.setMateInfo(ssoLoggerMateInfoAdapter.getLoggerMateInfo());
        Set<Long> powerIds = powerCacheService.getPowerIdsByUrl(params.getUri());
        if(!powerIds.isEmpty()){
            Long powerId = Lists.newArrayList(powerIds).get(0);
            List<PowerDto> powerList = powerCacheService.getPowerWay(powerId);
            runnable.setRequestFunction(joiner.join(powerList.stream().map(PowerDto::getName).collect(Collectors.toList())));
        }else {
            runnable.setRequestFunction("未添加权限映射");
        }
        ssoLoggerService.sendAccessLog(runnable);
        return true;
    }

}
