package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import org.springframework.stereotype.Component;

@Component
public class SystemFilterHandler implements SsoFilterHandler {

    @Override
    public Boolean before(Object handler) throws SsoException {
        AdminDto admin = RequestTool.getAdmin();
        SystemDto system = SystemInfo.getThisSystemInfo();
        if(!admin.getSystemIdSet().contains(system.getId())){
            CookieUtil.deleteCookie(CookieUtil.LOGIN_COOKIE_NAME);//去除当前系统的Cookie
            throw new SsoException("尊敬的"+admin.getName()+"，您暂时没有"+system.getAppName()+"的访问权限，请联系本部门HR开通");
        }
        return true;
    }

    @Override
    public int getOrder() {
        return 5;
    }
}
