package cn.com.duiba.sso.api.web.interceptor.queue;

import cn.com.duiba.sso.api.web.interceptor.MobileInterceptor;
import cn.com.duiba.sso.api.web.interceptor.SsoInterceptor;
import cn.com.duiba.sso.api.web.interceptor.annotation.MobileHandler;
import cn.com.duiba.sso.api.web.interceptor.annotation.OnlyMobileHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import com.google.common.base.Objects;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;

@Component
public class SsoInterceptorBuilder {

    @Resource
    private List<SsoFilterHandler> ssoFilterHandlers;
    @Resource
    private MobileInterceptor mobileInterceptor;
    @Resource
    private SsoInterceptor ssoInterceptor;

    /**
     * 获取指定接口的拦截队列
     * @return
     */
    @PostConstruct
    public void buildHandlerQueue(){

        SsoFilterHandlerQueue mobilequeue = new SsoFilterHandlerQueue();
        SsoFilterHandlerQueue queue = new SsoFilterHandlerQueue();
        for (SsoFilterHandler handler:ssoFilterHandlers) {

            MobileHandler mobileHandler = AnnotationUtils.findAnnotation(handler.getClass(),MobileHandler.class);
            OnlyMobileHandler onlyMobileHandler = AnnotationUtils.findAnnotation(handler.getClass(),OnlyMobileHandler.class);

            if(!Objects.equal(null,onlyMobileHandler)){
                mobilequeue.addHandler(handler);
                continue;
            }
            queue.addHandler(handler);

            if(!Objects.equal(null,mobileHandler)){
                mobilequeue.addHandler(handler);
            }
        }

        mobileInterceptor.setHandleQueue(mobilequeue);
        ssoInterceptor.setHandleQueue(queue);
    }


}
