package cn.com.duiba.sso.api.web.logger;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerMateInfo;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.tool.RequestParams;
import cn.com.duiba.sso.api.tool.RequestTool;
import org.springframework.stereotype.Component;

@Component
public class DefaultSsoLoggerMateInfoAdapter implements SsoLoggerMateInfoAdapter {

    @Override
    public SsoLoggerMateInfo getLoggerMateInfo() {

        SsoLoggerMateInfo mateInfo = new SsoLoggerMateInfo();
        RequestParams requestParams = RequestTool.getRequestParams();
        if(requestParams!=null){
            AdminDto admin = requestParams.getAdmin();
            if(admin!=null){
                mateInfo.setAdminName(admin.getName());
            }
            mateInfo.setIp(requestParams.getIp());
            mateInfo.setUri(requestParams.getUri());
            mateInfo.setUrl(requestParams.getUrl());
        }
        return mateInfo;
    }


    @Override
    public Long getAdminId() {
        RequestParams requestParams = RequestTool.getRequestParams();
        if(requestParams==null){//异步线程
            return 0L;
        }
        AdminDto admin = requestParams.getAdmin();
        if(admin==null){//异步线程
            return 0L;
        }
        return admin.getId();
    }
}
