/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.event.SsoLoginSuccessEvent;
import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.service.eventbus.SsoEventBus;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/auth"})
public class AuthController {
    private static Logger logger = LoggerFactory.getLogger(AuthController.class);
    @Autowired
    private AdminPowerCacheService adminPowerCacheService;
    @Autowired
    private RemotePermissionService remotePermissionService;
    @Autowired
    private SsoProperties properties;
    @Autowired
    private RemoteSSOService remoteSSOService;
    @Autowired
    private SsoEventBus ssoEventBus;

    @CanAccess
    @RequestMapping(value={"/ssoIndex"})
    public void ssoIndex(@RequestParam Long ssoStamp, @RequestParam(required=false) String redirect, @RequestParam(defaultValue="1") Integer ssoType) throws IOException {
        HttpServletResponse response = RequestTool.getResponse();
        try {
            Long systemId = SystemInfo.getThisSystemId();
            String ticket = this.remoteSSOService.findTicketByStamp(systemId, ssoStamp);
            switch (ssoType) {
                case 1: {
                    CookieUtil.setCookie("sso_ticket", ticket);
                    break;
                }
                case 2: {
                    CookieUtil.setCookie("sso_user_id", ticket);
                }
            }
            AdminDto admin = this.remoteSSOService.verifyTicketAndGetAdmin(ticket);
            SsoLoginSuccessEvent event = new SsoLoginSuccessEvent();
            event.setAdminId(admin.getId());
            this.ssoEventBus.post((Object)event);
            String url = Optional.ofNullable(redirect).orElse(this.properties.getDefaultRedirectUrl());
            response.sendRedirect(url);
        }
        catch (Exception e) {
            logger.error("\u8df3\u8f6c\u767b\u5f55\u5931\u8d25", (Throwable)e);
            response.getWriter().write("\u8df3\u8f6c\u767b\u5f55\u5931\u8d25");
        }
    }

    @AuthCanAccess
    @ResponseBody
    @RequestMapping(value={"/getAuthList"})
    public JsonRender getAuthList() {
        Set<String> urlSet = this.adminPowerCacheService.getAllPowerRes(RequestTool.getAdminId());
        Long version = this.adminPowerCacheService.version(RequestTool.getAdminId());
        AdminDto admin = RequestTool.getAdmin();
        JSONObject json = new JSONObject();
        json.put("version", (Object)version);
        json.put("nowVersion", (Object)this.remotePermissionService.getAdminPowerVersion(SystemInfo.getThisSystemId(), RequestTool.getAdminId()));
        json.put("authList", (Object)Lists.newArrayList(urlSet));
        return JsonRender.successResult(json);
    }

    @ResponseBody
    @RequestMapping(value={"/cleanAuth"})
    public JsonRender cleanAuth() {
        this.adminPowerCacheService.clean(RequestTool.getAdminId());
        return JsonRender.successResult();
    }
}

