/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.tool;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestParams;
import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RequestTool
implements ApplicationContextAware {
    private static ThreadLocal<RequestTool> local = new ThreadLocal();
    private static RemoteAdminService remoteAdminService;
    private static RemoteSSOService remoteSSOService;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private RequestParams params;

    public static void setRequestInThreadLocal(HttpServletRequest request, HttpServletResponse response) {
        if (request == null) {
            throw new SsoRunTimeException("RequestTool\u6ce8\u5165request\u4e3a\u7a7a");
        }
        if (response == null) {
            throw new SsoRunTimeException("RequestTool\u6ce8\u5165response\u4e3a\u7a7a");
        }
        RequestTool tool = new RequestTool();
        tool.request = request;
        tool.response = response;
        tool.params = RequestParams.parse(request);
        local.set(tool);
    }

    private static RequestTool get() {
        if (local.get() == null) {
            throw new SsoRunTimeException("\u8bf7\u5728\u767b\u5f55\u62e6\u622a\u5668\u4e2d\u8c03\u7528setRequestInThreadLocal,\u6216\u8005\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u5f02\u6b65\u7ebf\u7a0b\u4e2d\u4f7f\u7528RequestTool,\u5982\u679c\u6709\u5f02\u6b65\u573a\u666f\u8981\u83b7\u53d6\u7528\u6237\u4fe1\u606f,\u8bf7\u5728\u5f02\u6b65\u7ebf\u7a0b\u542f\u52a8\u4e4b\u524d\u4f7f\u7528getRequestParams\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u8bf7\u6c42\u5c01\u88c5\u4fe1\u606f");
        }
        return local.get();
    }

    public static RequestParams getRequestParams() {
        if (local.get() == null) {
            return null;
        }
        return RequestTool.get().params.clone();
    }

    public static HttpServletResponse getResponse() {
        return RequestTool.get().response;
    }

    public static HttpServletRequest getRequest() {
        return RequestTool.get().request;
    }

    public static void removeRequestInThreadLocal() {
        local.remove();
    }

    public static Long getAdminId() {
        AdminDto admin = RequestTool.getAdmin();
        return Optional.ofNullable(admin).map(AdminDto::getId).orElse(null);
    }

    public static AdminDto getAdmin() {
        RequestTool tool = RequestTool.get();
        return tool.params.getAdmin();
    }

    public static void setAdmin(AdminDto admin) {
        RequestTool tool = RequestTool.get();
        tool.params.setAdmin(admin);
    }

    public static void addCookie(Cookie cookie) {
        if (cookie == null) {
            return;
        }
        RequestTool tool = RequestTool.get();
        tool.params.addCookie(cookie.getName(), cookie.getValue());
        tool.response.addCookie(cookie);
    }

    public static String getUrl() {
        return RequestTool.get().params.getUrl();
    }

    public static boolean isHttpsRequest() {
        HttpServletRequest request = RequestTool.get().request;
        return "true".equals(request.getHeader("Use-Https"));
    }

    public static String getCookie(String name) {
        RequestTool tool = RequestTool.get();
        return tool.params.getCookie(name);
    }

    public static Map<String, String> getRequestParamMap() {
        HttpServletRequest request = RequestTool.get().request;
        Map map = request.getParameterMap();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            String[] values = (String[])entry.getValue();
            if (values.length == 0) continue;
            resultMap.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return resultMap;
    }

    public static Boolean isAsynchronousRequests() {
        HttpServletRequest request = RequestTool.get().request;
        String re = request.getHeader("x-requested-with");
        String accept = request.getHeader("Accept");
        return StringUtils.isNotBlank((String)re) && StringUtils.equals((String)"XMLHttpRequest", (String)re) || StringUtils.isNotBlank((String)accept) && accept.contains("json");
    }

    public static String getIp() {
        RequestTool tool = RequestTool.get();
        return tool.params.getIp();
    }

    public static Boolean isLocalHost() {
        RequestTool tool = RequestTool.get();
        return Objects.equal((Object)tool.params.getIp(), (Object)"127.0.0.1");
    }

    public static void googleVerify(String code) throws SsoException {
        Long adminId = RequestTool.getAdminId();
        Boolean result = remoteAdminService.googleCodeVerify(adminId, code);
        if (!result.booleanValue()) {
            throw new SsoException("\u52a8\u6001\u7801\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    public static String getHomeURL() {
        String scheme = RequestTool.getRequest().getScheme();
        String serverName = RequestTool.getRequest().getServerName();
        int port = RequestTool.getRequest().getServerPort();
        return scheme + "://" + serverName + ":" + port;
    }

    public static String findTicket() {
        String ticketForUrl = RequestTool.getRequestParamMap().get("sso_ticket");
        if (StringUtils.isNotBlank((String)ticketForUrl)) {
            return ticketForUrl;
        }
        return CookieUtil.getCookie("sso_ticket");
    }

    public static String findMobileTicket() {
        return CookieUtil.getCookie("sso_user_id");
    }

    public static void outLogin() {
        String ticket = RequestTool.findTicket();
        if (StringUtils.isBlank((String)ticket)) {
            return;
        }
        CookieUtil.deleteCookie("sso_ticket");
        remoteSSOService.outLogin(ticket);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        remoteAdminService = (RemoteAdminService)context.getBean(RemoteAdminService.class);
        remoteSSOService = (RemoteSSOService)context.getBean(RemoteSSOService.class);
    }
}

