/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.queue;

import cn.com.duiba.sso.api.web.interceptor.MobileInterceptor;
import cn.com.duiba.sso.api.web.interceptor.SsoInterceptor;
import cn.com.duiba.sso.api.web.interceptor.annotation.MobileHandler;
import cn.com.duiba.sso.api.web.interceptor.annotation.OnlyMobileHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.queue.SsoFilterHandlerQueue;
import com.google.common.base.Objects;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class SsoInterceptorBuilder {
    @Resource
    private List<SsoFilterHandler> ssoFilterHandlers;
    @Resource
    private MobileInterceptor mobileInterceptor;
    @Resource
    private SsoInterceptor ssoInterceptor;

    @PostConstruct
    public void buildHandlerQueue() {
        SsoFilterHandlerQueue mobilequeue = new SsoFilterHandlerQueue();
        SsoFilterHandlerQueue queue = new SsoFilterHandlerQueue();
        for (SsoFilterHandler handler : this.ssoFilterHandlers) {
            MobileHandler mobileHandler = (MobileHandler)AnnotationUtils.findAnnotation(handler.getClass(), MobileHandler.class);
            OnlyMobileHandler onlyMobileHandler = (OnlyMobileHandler)AnnotationUtils.findAnnotation(handler.getClass(), OnlyMobileHandler.class);
            if (!Objects.equal(null, (Object)onlyMobileHandler)) {
                mobilequeue.addHandler(handler);
                continue;
            }
            queue.addHandler(handler);
            if (Objects.equal(null, (Object)mobileHandler)) continue;
            mobilequeue.addHandler(handler);
        }
        this.mobileInterceptor.setHandleQueue(mobilequeue);
        this.ssoInterceptor.setHandleQueue(queue);
    }
}

