package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.annotation.MobileHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.AuthFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Created by liuyao on 2017/5/12.
 * 远程权限拦截系统
 */
@MobileHandler
@Component
public class AuthorityFilterHandler extends AuthFilterHandler implements SsoFilterHandler {


    @Override
    public int getOrder() {
        return 10;
    }
    @Autowired
    private AdminPowerCacheService adminPowerCacheService;

    @Override
    public Boolean before(Object handler){
        if (hasAuthCanAccess(handler)){
            return true;
        }

        HttpServletRequest request = RequestTool.getRequest();

        String url = request.getRequestURI();

        if(adminPowerCacheService.hasPower(RequestTool.getAdminId(),url)){
            return true;
        }else{
            dontHasPower("无权访问");
            return false;
        }
    }
}
