package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import cn.com.duiba.sso.api.constants.SsoProperties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.net.URLEncoder;

/**
 * Created by liuyao on 2017/5/11.
 * 单点登录拦截系统
 */
@Component
public class LoginFilterHandler extends AbstractLoginFilterHandler {

    private static Logger logger = LoggerFactory.getLogger(LoginFilterHandler.class);

    @Resource
    private RemoteSSOService remoteSSOService;
    @Resource
    protected SsoBasicProperties properties;

    @Resource
    protected SsoProperties ssoProperties;

    @Override
    public Boolean before(Object handler){
        String ticket = RequestTool.findTicket();
        if(StringUtils.isBlank(ticket)){
            returnNotLogin();
            return false;
        }
        try{
            AdminDto admin = remoteSSOService.verifyTicketAndGetAdmin(ticket);
            if(admin==null){
                throw new SsoException("通行证失效");
            }
            //注入adminId
            RequestTool.setAdmin(admin);

            //*****************************确认所有客户端都升成1.3.0之后删除********************
            //当通行令牌存在于链接参数中时,则把它持久到cookie中(链接中通行证的参数名和链接中的相同)
            if(RequestTool.getRequestParamMap().containsKey(CookieUtil.LOGIN_COOKIE_NAME)){
                CookieUtil.setCookie(CookieUtil.LOGIN_COOKIE_NAME,ticket);
            }
            //*****************************确认所有客户端都升成1.3.0之后删除********************
            return true;
        }catch (Exception e){
            logger.info("通行证验证失败",e);
            returnNotLogin();
            return false;
        }
    }

    /**
     * 获取登录重定向地址
     * @param redirect
     * @return
     */
    @Override
    protected String getLoginRedirectUrl(String redirect){
        StringBuilder builder = new StringBuilder();
        String loginUrl = properties.getSsoSystemUrl() + "/login";
        builder.append(loginUrl).append("?redirect=").append(redirect);
        builder.append("&systemId=").append(SystemInfo.getThisSystemId());
        return builder.toString();
    }

    @Override
    protected String getDefaultRedirectUrl(){
        return ssoProperties.getDefaultRedirectUrl();
    }

}
