package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.handler.AuthFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import com.google.common.base.Objects;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

@Component
public class SystemFilterHandler extends AuthFilterHandler implements SsoFilterHandler {

    @Override
    public Boolean before(Object handler){
        if (hasAuthCanAccess(handler)){
            return true;
        }
        SystemDto system = SystemInfo.getThisSystemInfo();
        if(system==null){
            throw new SsoRunTimeException("查询当前系统信息失败");
        }
        AdminDto admin = RequestTool.getAdmin();
        if(admin==null){
            return false;
        }
        if(admin.getSystemIdSet()==null){
            throw new SsoRunTimeException("用户可操作系统列表异常");
        }
        if(!admin.getSystemIdSet().contains(system.getId())){
            dontHasPower("尊敬的"+admin.getName()+"，您暂时没有"+system.getAppName()+"的访问权限，请联系本部门HR开通");
            return false;
        }else{
            return true;
        }
    }

    @Override
    public int getOrder() {
        return 5;
    }
}
