/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api;

import cn.com.duiba.sso.api.SsoBasicConfiguration;
import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.MobileInterceptor;
import cn.com.duiba.sso.api.web.interceptor.SsoInterceptor;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ComponentScan(value={"cn.com.duiba.sso.api.web"})
@ConditionalOnWebApplication
@AutoConfigureAfter(value={SsoBasicConfiguration.class})
@EnableConfigurationProperties(value={SsoProperties.class})
@Import(value={SsoBasicConfiguration.class})
@ImportResource(value={"classpath:sso-api-task.xml"})
@Order(value=-1)
public class SsoAutoConfiguration
extends WebMvcConfigurerAdapter {
    @Resource
    private SsoInterceptor ssoInterceptor;
    @Resource
    private MobileInterceptor mobileInterceptor;
    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private SsoLoggerService ssoLoggerService;
    @Resource
    private SsoLoggerMateInfoAdapter ssoLoggerMateInfoAdapter;

    public void addInterceptors(InterceptorRegistry registry) {
        String pathPatterns = this.ssoProperties.getPathPatterns();
        String excludePathPatterns = this.ssoProperties.getExcludePathPatterns();
        String[] paths = StringUtils.split((String)pathPatterns, (String)",");
        String[] excludePath = StringUtils.isEmpty((String)excludePathPatterns) ? new String[]{} : StringUtils.split((String)excludePathPatterns, (String)",");
        InterceptorRegistration registration = registry.addInterceptor((HandlerInterceptor)this.ssoInterceptor).addPathPatterns(paths).addPathPatterns(new String[]{"/auth/**"}).excludePathPatterns(excludePath);
        super.addInterceptors(registry);
        this.ssoLoggerService.setSsoLoggerMateInfoAdapter(this.ssoLoggerMateInfoAdapter);
        if (!this.ssoProperties.getMobileEnable().booleanValue()) {
            return;
        }
        String mobilePathPatterns = this.ssoProperties.getMobilePathPatterns();
        String[] mobilePaths = StringUtils.split((String)mobilePathPatterns, (String)",");
        registration.excludePathPatterns(mobilePaths);
        InterceptorRegistration mobileRegistration = registry.addInterceptor((HandlerInterceptor)this.mobileInterceptor).addPathPatterns(mobilePaths).excludePathPatterns(excludePath);
        if (!StringUtils.equals((String)pathPatterns, (String)"/**")) {
            mobileRegistration.excludePathPatterns(paths);
        }
    }

    @Bean
    public RequestTool initRequestTool() {
        return new RequestTool();
    }
}

