package cn.com.duiba.sso.api.constants;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "duiba.sso")
public class SsoProperties {



    /**
     * 登录成功后默认的跳转地址，一般为首页地址
     */
    private String defaultRedirectUrl = "/";

    /**
     * sso要拦截的url，配置多个地址用","分隔
     * 若没配置，就采用默认值/** 拦截所有
     */
    private String pathPatterns = "/**";

    /**
     * 排除的路径，sso不拦截
     */
    private String excludePathPatterns;

    /**
     * 是否启动mobile
     */
    private Boolean mobileEnable = false;
    /**
     * 移动端默认跳转地址
     */
    private String mobileDefaultRedirectUrl = "/mobile/index";

    private String mobilePathPatterns = "/mobile**/**";

    public String getDefaultRedirectUrl() {
        return defaultRedirectUrl;
    }

    public void setDefaultRedirectUrl(String defaultRedirectUrl) {
        this.defaultRedirectUrl = defaultRedirectUrl;
    }

    public String getPathPatterns() {
        return pathPatterns;
    }

    public void setPathPatterns(String pathPatterns) {
        this.pathPatterns = pathPatterns;
    }

    public String getExcludePathPatterns() {
        return excludePathPatterns;
    }

    public void setExcludePathPatterns(String excludePathPatterns) {
        this.excludePathPatterns = excludePathPatterns;
    }

    public Boolean getMobileEnable() {
        return mobileEnable;
    }

    public void setMobileEnable(Boolean mobileEnable) {
        this.mobileEnable = mobileEnable;
    }

    public String getMobileDefaultRedirectUrl() {
        return mobileDefaultRedirectUrl;
    }

    public void setMobileDefaultRedirectUrl(String mobileDefaultRedirectUrl) {
        this.mobileDefaultRedirectUrl = mobileDefaultRedirectUrl;
    }

    public String getMobilePathPatterns() {
        return mobilePathPatterns;
    }

    public void setMobilePathPatterns(String mobilePathPatterns) {
        this.mobilePathPatterns = mobilePathPatterns;
    }
}

