package cn.com.duiba.sso.api.tool;

import java.io.IOException;
import java.io.PrintWriter;

import com.alibaba.fastjson.util.IOUtils;
import org.slf4j.Logger;

import com.alibaba.fastjson.JSONObject;
import org.slf4j.LoggerFactory;

/**
 * 请求响应结果，支持jsonp响应
 *
 * <p>固定参数：success标明请求处理结果，message响应附加信息（主要用于处理失败时的信息提示）
 * callback保存回调函数名称,在jsonp请求时非空</p>
 *
 * @author xiaoxuda 16/11/22
 * @author liuyao 16/11/24
 */
public class JsonRender extends JSONObject {

    private static final Logger log = LoggerFactory.getLogger(JsonRender.class);

    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";
    private static final String CALLBACK = "callback";
    private static final String DATA = "data";

    private JsonRender(){}

    /**
     * 构造一个成功状态的数据
     *
     * @return
     */
    public static JsonRender successResult() {
        JsonRender resp = new JsonRender();
        resp.put("success", true);
        return resp;
    }

    /**
     * 为了兼容旧接口，新数据接口请使用data做数据返回
     *
     * @param model
     * @return
     */
    public static JsonRender successResult(JSONObject model) {
        JsonRender resp = new JsonRender();
        resp.put(JsonRender.SUCCESS, true);
        resp.putAll(model);
        return resp;
    }

    /**
     * 用给定data构造一个成功状态的数据
     *
     * @param obj
     * @return
     */
    public static JsonRender successResult(Object obj) {
        JsonRender resp = new JsonRender();
        resp.put(JsonRender.SUCCESS, true);
        resp.put(JsonRender.DATA, obj);
        return resp;
    }

    /**
     * 设置data字段
     *
     * @param obj
     * @return
     */
    public JsonRender setData(Object obj) {
        this.put(JsonRender.DATA, obj);
        return this;
    }

    /**
     * 用失败信息构造一个失败状态的数据
     *
     * @param message
     * @return
     */
    public static JsonRender failResult(String message) {
        JsonRender resp = new JsonRender();
        resp.put(JsonRender.SUCCESS, false);
        resp.put(JsonRender.MESSAGE, message);
        return resp;
    }

    /**
     * 异常信息构造一个失败状态的数据
     *
     * @param e
     * @return
     */
    public static JsonRender failResult(Throwable e) {
        JsonRender resp = new JsonRender();
        resp.put(JsonRender.SUCCESS, false);
        resp.put(JsonRender.MESSAGE, e.getMessage());
        return resp;
    }


    /**
     * jsonp响应时传入回调函数名称
     *
     * @param callback
     * @return
     */
    public JsonRender setJSONPCallback(String callback) {
        this.put(JsonRender.CALLBACK, callback);
        return this;
    }

    /**
     * 请求处理结果
     *
     * @return
     */
    public boolean isSuccess() {
        return this.getBoolean(JsonRender.SUCCESS);
    }

    /**
     * 设置响应提示信息
     *
     * @param message
     */
    public JsonRender setMessage(String message) {
        this.put(JsonRender.MESSAGE, message);
        return this;
    }

    /**
     * 写入返回值,为了兼容旧接口，不建议使用，统一通过data字段返回数据给前端
     * @param key
     * @param result
     * @return
     */
    public JsonRender addResult(String key, Object result) {
        this.put(key, result);
        return this;
    }

    /**
     * jsonp处理
     * @param callback
     */
    public void forJsonpReturn(String callback) {
        PrintWriter out = null;
        try {
            out = RequestTool.getResponse().getWriter();
            out.write(callback + "(" + this.toJSONString() + ")");

        } catch (IOException e) {
            log.error("e={}", e);
        } finally {
            IOUtils.close(out);
        }
    }
}
