package cn.com.duiba.sso.api.web.interceptor.handler;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public abstract class AuthFilterHandler {

    protected Boolean hasAuthCanAccess(Object handler){
        if(handler instanceof HandlerMethod){
            HandlerMethod method = (HandlerMethod)handler;
            AuthCanAccess canAccess = AnnotationUtils.findAnnotation(method.getMethod(),AuthCanAccess.class);
            return !Objects.equal(null, canAccess);
        }
        return false;
    }

    protected void dontHasPower(String message){

        HttpServletResponse response = RequestTool.getResponse();
        String context;

        if(RequestTool.isAsynchronousRequests()){
            JSONObject json = new JSONObject();
            json.put("code","SSO:01002");
            json.put("success",false);
            json.put("desc","无权访问");
            json.put("message",message);
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            context = json.toJSONString();
        }else{//重定向到无权页面
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            context = message;
        }
        try {
            response.getWriter().write(context);
        } catch (IOException e) {
            throw new SsoRunTimeException(e);
        }
    }



}
