/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor;

import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.SsoFilterHandlerQueue;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AbstractInterceptor
extends HandlerInterceptorAdapter {
    private SsoFilterHandlerQueue queue;
    static final Set<String> EXCLUDE_PATHS = Sets.newHashSet();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        response.setCharacterEncoding("UTF-8");
        RequestTool.setRequestInThreadLocal(request, response);
        try {
            Boolean flag = this.canAccess(request, handler);
            if (flag != null) {
                return flag;
            }
            if (!this.queue.doHandler(handler).booleanValue()) {
                return false;
            }
        }
        catch (SsoException e) {
            if (RequestTool.isAsynchronousRequests().booleanValue()) {
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                response.getWriter().write(JsonRender.failResult(e).toJSONString());
            } else {
                response.setHeader("Content-Type", "text/html;charset=UTF-8");
                response.getWriter().write(e.getMessage());
            }
            return false;
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        RequestTool.removeRequestInThreadLocal();
    }

    public void setHandleQueue(SsoFilterHandlerQueue queue) {
        this.queue = queue;
    }

    private Boolean canAccess(HttpServletRequest request, Object handler) {
        HandlerMethod method;
        CanAccess canAccess;
        Boolean flag = (Boolean)request.getAttribute("CanAccess");
        if (flag != null) {
            return flag;
        }
        String url = request.getRequestURI();
        if (EXCLUDE_PATHS.contains(url)) {
            return true;
        }
        if (handler instanceof HandlerMethod && !Objects.equal(null, (Object)(canAccess = (CanAccess)AnnotationUtils.findAnnotation((Method)(method = (HandlerMethod)handler).getMethod(), CanAccess.class)))) {
            return true;
        }
        return null;
    }

    static {
        EXCLUDE_PATHS.add("/favicon.ico");
        EXCLUDE_PATHS.add("/monitor/check");
        EXCLUDE_PATHS.add("/swagger-ui.html");
        EXCLUDE_PATHS.add("/swagger-resources");
        EXCLUDE_PATHS.add("/swagger-resources/configuration/ui");
        EXCLUDE_PATHS.add("/v2/api-docs");
        EXCLUDE_PATHS.add("/error");
    }
}

