/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.power;

import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.service.power.PowerTreeCache;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.power.PowerCache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AdminPowerCacheService {
    private static Logger logger = LoggerFactory.getLogger(AdminPowerCacheService.class);
    private LoadingCache<Long, PowerCache> adminPowerCache = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new AdminRoleCacheLoader());
    @Autowired
    private RemotePermissionService remotePermissionService;
    @Autowired
    private PowerTreeService powerTreeService;

    private PowerCache getPowerCache(Long adminId) {
        return (PowerCache)this.adminPowerCache.get((Object)adminId);
    }

    public Boolean hasPower(Long adminId, String powerPath) {
        PowerTreeCache powerTreeCache = this.powerTreeService.getPowerTreeCache(SystemInfo.getThisSystemId());
        Set pawerIds = powerTreeCache.getPowerIdsByUrl(powerPath);
        if (pawerIds.isEmpty()) {
            return true;
        }
        PowerCache cache = this.getPowerCache(adminId);
        return !Sets.intersection((Set)pawerIds, cache.getPowerIdSet()).isEmpty();
    }

    public Set<Long> hasPowerIds(Long adminId, String powerPath) {
        PowerTreeCache powerTreeCache = this.powerTreeService.getPowerTreeCache(SystemInfo.getThisSystemId());
        Set pawerIds = powerTreeCache.getPowerIdsByUrl(powerPath);
        if (pawerIds.isEmpty()) {
            return Collections.emptySet();
        }
        PowerCache cache = this.getPowerCache(adminId);
        return Sets.intersection((Set)pawerIds, cache.getPowerIdSet());
    }

    public Set<String> getAllPowerRes(Long adminId) {
        PowerCache cache = this.getPowerCache(adminId);
        Set<Long> powerIds = cache.getPowerIdSet();
        HashSet urlSet = Sets.newHashSet();
        PowerTreeCache powerTreeCache = this.powerTreeService.getPowerTreeCache(SystemInfo.getThisSystemId());
        for (Long id : powerIds) {
            PowerDto power = powerTreeCache.getPower(id);
            if (power == null) continue;
            urlSet.addAll(power.getUrls());
        }
        return urlSet;
    }

    public Long version(Long adminId) {
        PowerCache cache = this.getPowerCache(adminId);
        return cache.getVersion();
    }

    public void clean(Long adminId) {
        this.adminPowerCache.invalidate((Object)adminId);
    }

    public void adminPowerFlushTask() {
        try {
            Long systemId = SystemInfo.getThisSystemId();
            Set adminIds = this.adminPowerCache.asMap().keySet();
            for (Long adminId : adminIds) {
                PowerCache cache = (PowerCache)this.adminPowerCache.getIfPresent((Object)adminId);
                if (cache == null) {
                    return;
                }
                Long version = this.remotePermissionService.getAdminPowerVersion(systemId, adminId);
                if (cache.getVersion() >= version) {
                    return;
                }
                this.adminPowerCache.invalidate((Object)adminId);
            }
        }
        catch (Exception e) {
            logger.error("\u7ba1\u7406\u5458\u6743\u9650\u68c0\u6d4b\u5931\u8d25", (Throwable)e);
        }
    }

    private class AdminRoleCacheLoader
    implements CacheLoader<Long, PowerCache> {
        private AdminRoleCacheLoader() {
        }

        public PowerCache load(Long adminId) {
            Long systemId = SystemInfo.getThisSystemId();
            Set powerIds = AdminPowerCacheService.this.remotePermissionService.getPowerIdsBySystemIdAndAdminId(systemId, adminId);
            PowerCache cache = new PowerCache(AdminPowerCacheService.this.remotePermissionService.getAdminPowerVersion(systemId, adminId));
            cache.setPowerIdSet(powerIds);
            return cache;
        }
    }
}

