/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.domain.enums.SsoTypeEnum;
import cn.com.duiba.sso.api.event.SsoLoginSuccessEvent;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.service.eventbus.SsoEventBus;
import cn.com.duiba.sso.api.service.system.SsoSystemService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.controller.AuthController;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sso"})
public class SsoController {
    private static Logger logger = LoggerFactory.getLogger(AuthController.class);
    @Autowired
    private RemoteSSOService remoteSSOService;
    @Autowired
    private SsoEventBus ssoEventBus;
    @Autowired
    private SsoProperties properties;
    @Autowired
    private SsoSystemService ssoSystemService;

    @CanAccess
    @RequestMapping(value={"/ssoIndex"})
    public void ssoIndex(@RequestParam Long ssoStamp, @RequestParam(required=false) String redirect) throws IOException {
        HttpServletResponse response = RequestTool.getResponse();
        try {
            redirect = this.fixRedirect(redirect);
            Long systemId = SystemInfo.getThisSystemId();
            String ticket = this.remoteSSOService.findTicketByStamp(systemId, ssoStamp);
            CookieUtil.setCookie("sso_ticket", ticket);
            AdminDto admin = this.remoteSSOService.verifyTicketAndGetAdmin(ticket);
            if (admin == null) {
                throw new SsoException("ticket\u5931\u6548");
            }
            SsoLoginSuccessEvent event = new SsoLoginSuccessEvent();
            event.setAdminId(admin.getId());
            event.setSsoTypeEnum(SsoTypeEnum.PC);
            this.ssoEventBus.post((Object)event);
            String url = Optional.ofNullable(redirect).orElse(this.properties.getDefaultRedirectUrl());
            response.sendRedirect(url);
        }
        catch (Exception e) {
            logger.debug("\u8df3\u8f6c\u767b\u5f55\u5931\u8d25", (Throwable)e);
            response.getWriter().write("\u8df3\u8f6c\u767b\u5f55\u5931\u8d25");
        }
    }

    @CanAccess
    @ResponseBody
    @RequestMapping(value={"/systemInfo"})
    public JsonRender systemInfo() {
        JsonRender render = JsonRender.successResult();
        render.put("ssoHomeURL", this.ssoSystemService.getSsoHomeUrl());
        SystemDto systemDto = SystemInfo.getThisSystemInfo();
        render.put("system", systemDto);
        return render;
    }

    private String fixRedirect(String url) {
        if (StringUtils.isBlank((String)url)) {
            return url;
        }
        return url.replace("&amp;", "&");
    }

    @ResponseBody
    @RequestMapping(value={"/outLogin"})
    public JsonRender outLogin() {
        RequestTool.outLogin();
        return JsonRender.successResult();
    }
}

