package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.domain.enums.SystemSwitches;
import cn.com.duiba.sso.api.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.service.system.SsoSystemService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SignTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.PcHandler;
import cn.com.duiba.wolf.utils.UrlUtils;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.net.URLDecoder;
import java.util.Map;

/**
 * Created by liuyao on 2017/5/11.
 * 单点登录拦截系统
 */
@PcHandler
public class LoginFilterHandler extends AbstractLoginFilterHandler {

    private static Logger logger = LoggerFactory.getLogger(LoginFilterHandler.class);

    @Resource
    private SsoBasicProperties properties;
    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private SsoSystemService ssoSystemService;

    @Override
    public Boolean before(Object handler) {

        String ticket = RequestTool.findTicket();

        AdminDto admin = verifyTicket(ticket);
        SystemDto system = SystemInfo.getThisSystemInfo();

        AdminDto mobileVerifyAdmin = null;
        //当系统的移动端是启动的，检测是否可以进行通行证的互认
        if(admin==null
                && ssoProperties.getMobileEnable()
                && !RequestTool.isAsynchronousRequests()
                && system.switchIsOpen(SystemSwitches.CAN_MOBILE_TO_PC)
        ){
            String mobileTicket = RequestTool.findMobileTicket();
            mobileVerifyAdmin = verifyTicket(mobileTicket);
        }

        if(mobileVerifyAdmin!=null){
            redirectMobileAuthorize();
        }
        //通过手机端授权的ticket不能在未打开 CAN_MOBILE_TO_PC 开关的系统中通行
        if(admin!=null && !system.switchIsOpen(SystemSwitches.CAN_MOBILE_TO_PC) && admin.getModelAuthorize()){
            admin = null;
        }

        if(admin==null && mobileVerifyAdmin==null){
            returnNotLogin();
        }
        if(admin==null){
            return false;
        }
        //注入adminId
        RequestTool.setAdmin(admin);
        return true;
    }

    /**
     * 获取登录重定向地址
     */
    @Override
    protected String getLoginRedirectUrl(){

        String redirect = getCurrentRedirect();
        StringBuilder builder = new StringBuilder();
        String loginUrl = ssoSystemService.getSsoHomeUrl() + "/login";
        builder.append(loginUrl).append("?redirect=").append(redirect);
        builder.append("&").append(SystemInfo.SSO_ENV).append("=").append(SystemInfo.getEnvironment().getName());
        builder.append("&systemId=").append(SystemInfo.getThisSystemId());
        return builder.toString();
    }

    @Override
    protected String getDefaultRedirectUrl(){
        return ssoProperties.getDefaultRedirectUrl();
    }

    /**
     * 跳转到手机端授权页
     */
    private void redirectMobileAuthorize() {
        try{
            String redirect = getCurrentRedirect();

            SystemDto system = SystemInfo.getThisSystemInfo();

            Map<String,String> params = Maps.newHashMap();
            params.put("redirect", URLDecoder.decode(redirect,"utf-8"));
            params.put("systemId",system.getId().toString());
            params.put("timestamp",Long.toString(System.currentTimeMillis()));

            String sign = SignTool.sign(properties.getAppSecret(),params);
            params.put("sign",sign);
            params.put("redirect", redirect);//签名之后再把链接进行编码

            String mobileAuthorizeUrl = ssoSystemService.getSsoHomeUrl() + "/mobile/mobileAuthorize";

            mobileAuthorizeUrl =  UrlUtils.appendParams(mobileAuthorizeUrl,params);


            RequestTool.getResponse().sendRedirect(mobileAuthorizeUrl);
        }catch (Exception e){
            logger.error("redirectMobileAuthorize error",e);
        }
    }

}
