package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.PcHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.AuthFilterHandler;

@PcHandler
public class SystemFilterHandler extends AuthFilterHandler  {

    @Override
    public Boolean before(Object handler){
        if (hasAuthCanAccess(handler)){
            return true;
        }
        SystemDto system = SystemInfo.getThisSystemInfo();
        AdminDto admin = RequestTool.getAdmin();
        if(admin==null){
            return false;
        }
        if(admin.getSystemIdSet()==null){
            throw new SsoRunTimeException("用户可操作系统列表异常");
        }
        if(!admin.getSystemIdSet().contains(system.getId())){
            dontHasPower("尊敬的"+admin.getName()+"，您暂时没有"+system.getAppName()+"的访问权限，请联系本部门HR开通");
            return false;
        }else{
            return true;
        }
    }

    @Override
    public int getOrder() {
        return 5;
    }
}
