/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/auth", "/sso/auth"})
public class AuthController {
    @Autowired
    private AdminPowerCacheService adminPowerCacheService;
    @Autowired
    private RemotePermissionService remotePermissionService;

    @AuthCanAccess
    @ResponseBody
    @RequestMapping(value={"/getAuthList"})
    public JsonRender getAuthList() {
        Set<String> urlSet = this.adminPowerCacheService.getAllPowerRes(RequestTool.getAdminId());
        Long version = this.adminPowerCacheService.version(RequestTool.getAdminId());
        JSONObject json = new JSONObject();
        json.put("version", (Object)version);
        json.put("authList", (Object)Lists.newArrayList(urlSet));
        return JsonRender.successResult(json);
    }

    @ResponseBody
    @RequestMapping(value={"/getAuthVersion"}, method={RequestMethod.GET})
    public JsonRender getAuthVersion() {
        JSONObject json = new JSONObject();
        json.put("version", (Object)this.remotePermissionService.getAdminPowerVersion(SystemInfo.getThisSystemId(), RequestTool.getAdminId()));
        return JsonRender.successResult(json);
    }

    @ResponseBody
    @RequestMapping(value={"/cleanAuth"})
    public JsonRender cleanAuth() {
        this.adminPowerCacheService.clean(RequestTool.getAdminId());
        return JsonRender.successResult();
    }
}

