/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.handler;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.service.system.EnvironmentEnum;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public abstract class AuthFilterHandler
implements SsoFilterHandler {
    protected Boolean hasAuthCanAccess(Object handler) {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            AuthCanAccess canAccess = (AuthCanAccess)AnnotationUtils.findAnnotation((Method)method.getMethod(), AuthCanAccess.class);
            return !Objects.equal(null, (Object)canAccess);
        }
        if (!EnvironmentEnum.DEV.equals((Object)SystemInfo.getEnvironment())) {
            return false;
        }
        AdminDto admin = RequestTool.getAdmin();
        return StringUtils.equals((String)"swagger@duiba.com.cn", (String)admin.getEmail());
    }

    protected void dontHasPower(String message) {
        String context;
        HttpServletResponse response = RequestTool.getResponse();
        if (RequestTool.isAsynchronousRequests().booleanValue()) {
            JSONObject json = new JSONObject();
            json.put("code", (Object)"SSO:01002");
            json.put("success", (Object)false);
            json.put("desc", (Object)"\u65e0\u6743\u8bbf\u95ee");
            json.put("message", (Object)message);
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            context = json.toJSONString();
        } else {
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            context = message;
        }
        try {
            response.getWriter().write(context);
        }
        catch (IOException e) {
            throw new SsoRunTimeException((Throwable)e);
        }
    }
}

