package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.domain.enums.SsoTypeEnum;
import cn.com.duiba.sso.api.event.SsoLoginSuccessEvent;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.service.eventbus.SsoEventBus;
import cn.com.duiba.sso.api.service.system.SsoSystemService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;

@Controller
@RequestMapping("/sso")
public class SsoController {

    private static Logger logger = LoggerFactory.getLogger(AuthController.class);

    @Autowired
    private RemoteSSOService remoteSSOService;
    @Autowired
    private SsoEventBus ssoEventBus;
    @Autowired
    private SsoProperties properties;
    @Autowired
    private SsoSystemService ssoSystemService;

    @CanAccess
    @RequestMapping("/ssoIndex")
    public void ssoIndex(@RequestParam Long ssoStamp, @RequestParam(required = false) String redirect) throws IOException {

        HttpServletResponse response = RequestTool.getResponse();
        try{
            redirect = fixRedirect(redirect);
            Long systemId = SystemInfo.getThisSystemId();
            String ticket = remoteSSOService.findTicketByStamp(systemId,ssoStamp);
            CookieUtil.setCookie(CookieUtil.LOGIN_COOKIE_NAME,ticket);

            AdminDto admin = remoteSSOService.verifyTicketAndGetAdmin(ticket);
            if(admin==null){
                throw new SsoException("ticket失效");
            }
            SsoLoginSuccessEvent event = new SsoLoginSuccessEvent();
            event.setAdminId(admin.getId());
            event.setSsoTypeEnum(SsoTypeEnum.PC);
            ssoEventBus.post(event);

            String url = Optional.ofNullable(redirect).orElse(properties.getDefaultRedirectUrl());

            response.sendRedirect(url);
        }catch (Exception e){
            logger.debug("跳转登录失败",e);
            response.getWriter().write("跳转登录失败");
        }
    }

    /**
     * 当前的系统信息
     */
    @CanAccess
    @ResponseBody
    @RequestMapping(value = "/systemInfo")
    public JsonRender systemInfo(){

        JsonRender render = JsonRender.successResult();
        render.put("ssoHomeURL",ssoSystemService.getSsoHomeUrl());
        SystemDto systemDto = SystemInfo.getThisSystemInfo();
        render.put("system",systemDto);
        render.put(SystemInfo.SSO_ENV,SystemInfo.getEnvironment().getName());
        return render;
    }

    private String fixRedirect(String url){
        if(StringUtils.isBlank(url)){
            return url;
        }
        return StringEscapeUtils.unescapeHtml3(url);
    }

    @ResponseBody
    @RequestMapping(value = "/outLogin")
    public JsonRender outLogin(){
        RequestTool.outLogin();
        return JsonRender.successResult();
    }

}
