package cn.com.duiba.sso.api.web.interceptor;

import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * Created by liuyao on 2017/5/11.
 */
public class SsoFilterHandlerQueue {

    private List<SsoFilterHandler> queueHandlerList = Lists.newArrayList();

    public void addHandler(SsoFilterHandler bootFilterHandler){
        queueHandlerList.add(bootFilterHandler);
    }

    public Boolean doHandler(Object handler) throws SsoException {
        if(queueHandlerList.isEmpty()){
            return true;
        }
        for(SsoFilterHandler itemHandler:queueHandlerList){
            boolean doNext = itemHandler.before(handler);
            if(!doNext){
               return false;
            }
        }
        return true;
    }

    public Integer size(){
        return queueHandlerList.size();
    }
}
