package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;
import java.net.URLEncoder;

public abstract class AbstractLoginFilterHandler implements SsoFilterHandler {

    private static Logger logger = LoggerFactory.getLogger(AbstractLoginFilterHandler.class);

    @Autowired
    private RemoteSSOService remoteSSOService;

    @Override
    public int getOrder(){
        return 0;
    }

    public abstract Boolean before(Object handler);

    protected abstract String getDefaultRedirectUrl();

    protected abstract String getLoginRedirectUrl();

    /**
     * 验证通行证
     * @return
     */
    protected AdminDto verifyTicket(String ticket){
        if(StringUtils.isBlank(ticket)){
            return null;
        }
        return remoteSSOService.verifyTicketAndGetAdmin(ticket);
    }

    /**
     * 把当前请求包装成重定向参数
     * @return
     */
    protected String getCurrentRedirect(){
        HttpServletRequest request = RequestTool.getRequest();
        String redirect;
        if(StringUtils.equals("/",request.getRequestURI())){
            redirect = RequestTool.getHomeURL()+getDefaultRedirectUrl();
        }else{
            redirect = RequestTool.getUrl();
        }
        try{
            return URLEncoder.encode(redirect,"utf-8");
        }catch (Exception e){
            throw new SsoRunTimeException(e);
        }
    }

    protected void returnNotLogin(){
        try{
            if(RequestTool.isAsynchronousRequests()){
                RequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                JSONObject model = new JSONObject();
                model.put("code","SSO:01001");
                model.put("success",false);
                model.put("notLogin",true);
                model.put("message","登录失效，请刷新页面");
                RequestTool.getResponse().getWriter().write(model.toJSONString());
            }else{
                //附上当前请求地址,重定向到SSO登录页
                RequestTool.getResponse().sendRedirect(getLoginRedirectUrl());
            }
        }catch (Exception e){
            throw new SsoRunTimeException(e);
        }
    }

}
