/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.domain.enums.SystemSwitches;
import cn.com.duiba.sso.api.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.service.system.SsoSystemService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SignTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.AbstractLoginFilterHandler;
import cn.com.duiba.wolf.utils.UrlUtils;
import com.google.common.collect.Maps;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginFilterHandler
extends AbstractLoginFilterHandler {
    private static Logger logger = LoggerFactory.getLogger(LoginFilterHandler.class);
    @Resource
    private SsoBasicProperties properties;
    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private SsoSystemService ssoSystemService;

    @Override
    public Boolean before(Object handler) {
        String ticket = RequestTool.findTicket();
        AdminDto admin = this.verifyTicket(ticket);
        SystemDto system = SystemInfo.getThisSystemInfo();
        AdminDto mobileVerifyAdmin = null;
        if (admin == null && this.ssoProperties.getMobileEnable().booleanValue() && !RequestTool.isAsynchronousRequests().booleanValue() && system.switchIsOpen(SystemSwitches.CAN_MOBILE_TO_PC).booleanValue()) {
            String mobileTicket = RequestTool.findMobileTicket();
            mobileVerifyAdmin = this.verifyTicket(mobileTicket);
        }
        if (mobileVerifyAdmin != null) {
            this.redirectMobileAuthorize();
        }
        if (admin != null && !system.switchIsOpen(SystemSwitches.CAN_MOBILE_TO_PC).booleanValue() && admin.getModelAuthorize().booleanValue()) {
            admin = null;
        }
        if (admin == null && mobileVerifyAdmin == null) {
            this.returnNotLogin();
        }
        if (admin == null) {
            return false;
        }
        RequestTool.setAdmin(admin);
        if (RequestTool.getRequestParamMap().containsKey("sso_ticket")) {
            String requestTicket = RequestTool.getRequest().getParameter("sso_ticket");
            CookieUtil.setCookie("sso_ticket", requestTicket);
        }
        return true;
    }

    @Override
    protected String getLoginRedirectUrl() {
        String redirect = this.getCurrentRedirect();
        StringBuilder builder = new StringBuilder();
        String loginUrl = this.ssoSystemService.getSsoHomeUrl() + "/login";
        builder.append(loginUrl).append("?redirect=").append(redirect);
        builder.append("&systemId=").append(SystemInfo.getThisSystemId());
        return builder.toString();
    }

    @Override
    protected String getDefaultRedirectUrl() {
        return this.ssoProperties.getDefaultRedirectUrl();
    }

    private void redirectMobileAuthorize() {
        try {
            String redirect = this.getCurrentRedirect();
            SystemDto system = SystemInfo.getThisSystemInfo();
            HashMap params = Maps.newHashMap();
            params.put("redirect", URLDecoder.decode(redirect, "utf-8"));
            params.put("systemId", system.getId().toString());
            params.put("timestamp", Long.toString(System.currentTimeMillis()));
            String sign = SignTool.sign((String)this.properties.getAppSecret(), (Map)params);
            params.put("sign", sign);
            params.put("redirect", redirect);
            String mobileAuthorizeUrl = this.ssoSystemService.getSsoHomeUrl() + "/mobile/mobileAuthorize";
            mobileAuthorizeUrl = UrlUtils.appendParams((String)mobileAuthorizeUrl, (Map)params);
            RequestTool.getResponse().sendRedirect(mobileAuthorizeUrl);
        }
        catch (Exception e) {
            logger.error("redirectMobileAuthorize error", (Throwable)e);
        }
    }
}

